// only add update server if it's not being run from cli
if (require.main !== module) {
  require('update-electron-app')({
    logger: require('electron-log')
  })
}

const path = require('path')

const {app, BrowserWindow} = require('electron')

const debug = /--debug/.test(process.argv[2])

//if (process.mas) app.setName(‘Electron APIs’)

let mainWindow = null

function initialize () {
  makeSingleInstance()

  function createWindow () {
    const windowOptions = {
      width: 1280,
      minWidth: 1280,
      height: 720,
	  minHeight: 720,
	  //frame: false,
	  webPreferences: {
      // The `plugins` have to be enabled.
        plugins: true,
	devTools: false
	  },
      title: app.getName()
    }

    if (process.platform === 'linux') {
      windowOptions.icon = path.join(__dirname, '/assets/app-icon/png/512.png')
    }

    mainWindow = new BrowserWindow(windowOptions)
    mainWindow.setMenu(null)
    mainWindow.loadURL(path.join('https://fe.svc.ott.zala.by/'))

    mainWindow.on('closed', () => {
      mainWindow = null
    })
  }
  
	app.commandLine.appendSwitch('widevine-cdm-path', path.join(__dirname, 'WidevineCdm', '_platform_specific', 'mac_x64'))
	// The version of plugin can be got from `chrome://plugins` page in Chrome.
	// app.commandLine.appendSwitch('widevine-cdm-version', '4.10.1610.0’)

  app.on('ready', () => {
    createWindow()
  })

  app.on('window-all-closed', () => {
    if (process.platform !== 'darwin') {
      app.quit()
    }
  })

  app.on('activate', () => {
    if (mainWindow === null) {
      createWindow()
    }
  })
}

// Make this app a single instance app.
//
// The main window will be restored and focused instead of a second window
// opened when a person attempts to launch a second instance.
//
// Returns true if the current version of the app should quit instead of
// launching.
function makeSingleInstance () {
  if (process.mas) return

  app.requestSingleInstanceLock()

  app.on('second-instance', () => {
    if (mainWindow) {
      if (mainWindow.isMinimized()) mainWindow.restore()
      mainWindow.focus()
    }
  })
}


initialize()
